<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Members\EfileController; 
use App\Http\Controllers;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/






Route::get('/currentexport', 'Members\EfileController@currentexport');
Route::post('/searchdoc', 'Members\EfileController@searchdoc')->name('searchdoc');


// Route::post('/changepswd', [Members\EfileController::class, 'changepswd'])->name('changepswd');
Route::post('/changepswd', 'Members\EfileController@changepswd')->name('changepswd');
Route::post('/changepin', 'Members\EfileController@changepin')->name('changepin');


Route::post('/getdepusers', 'Members\EfileController@getdepusers')->name('getdepusers');



Route::get('/', function () {
    return redirect('/login');
    //return view('welcome');
});

Auth::routes();



Route::get('/home', 'HomeController@index')->name('home');
Route::get('/home-lawyer', 'HomeController@homelawyer')->name('homelawyer');
Route::get('admin/home', 'HomeController@handleAdmin')->name('admin.route');
//Route::get('admin/home', 'HomeController@handleAdmin')->name('admin.route')->middleware('admin');


/////Admin ROutes
//Member
Route::get('/add-new-member', 'Admin\MemberAdminController@addmember')->name('addmember');
Route::post('/store-new-member', 'Admin\MemberAdminController@storemember')->name('storemember');
Route::get('/view-member-list', 'Admin\MemberAdminController@viewmembers')->name('viewmembers');
Route::post('/edit-new-member', 'Admin\MemberAdminController@uploademember')->name('uploademember');
Route::post('/delete-member', 'Admin\MemberAdminController@deletemember')->name('deletemember');

//Section
Route::get('/add-new-section', 'Admin\DepartmentAdminController@adddepartment')->name('adddepartment');
Route::post('/store-new-section', 'Admin\DepartmentAdminController@storedepartment')->name('storedepartment');
Route::get('/view-section-list', 'Admin\DepartmentAdminController@viewdepartment')->name('viewdepartment');
Route::post('/edit-section', 'Admin\DepartmentAdminController@updatedep')->name('updatedep');
Route::post('/delete-section', 'Admin\DepartmentAdminController@deletedep')->name('deletedep');

//Department
Route::get('/add-new-department', 'Admin\DepartmentAdminController@addOdepartment')->name('addOdepartment');
Route::post('/store-new-department', 'Admin\DepartmentAdminController@storeOdepartment')->name('storeOdepartment');
Route::get('/view-department-list', 'Admin\DepartmentAdminController@viewOdepartment')->name('viewOdepartment');
Route::post('/edit-department', 'Admin\DepartmentAdminController@updateOdep')->name('updateOdep');
Route::post('/delete-department', 'Admin\DepartmentAdminController@deleteOdep')->name('deleteOdep');


//Job titles
Route::get('/add-new-job-title', 'Admin\DepartmentAdminController@addjobtitle')->name('addjobtitle');
Route::post('/store-job-title', 'Admin\DepartmentAdminController@storejobtitle')->name('storejobtitle');
Route::get('/view-job-title', 'Admin\DepartmentAdminController@viewjobtitle')->name('viewjobtitle');
Route::post('/edit-job-title', 'Admin\DepartmentAdminController@updatejobtitle')->name('updatejobtitle');
Route::post('/delete-Job-title', 'Admin\DepartmentAdminController@deletejobtitle')->name('deletejobtitle');




//Job titles
Route::get('/view-quick-replies', 'Admin\DepartmentAdminController@viewquickreply')->name('viewquickreply');
Route::post('/delete-quick-reply', 'Admin\DepartmentAdminController@deletequickrep')->name('deletequickrep');
Route::post('/edit-quick-reply', 'Admin\DepartmentAdminController@updatequickrep')->name('updatequickrep');




//Attendence
Route::get('/attendence', 'Admin\HrAdminController@attendence')->name('attendence');
Route::get('/mark-attendence', 'Admin\HrAdminController@markattendence')->name('markattendence');
Route::post('/Mark-department-attendence', 'Admin\HrAdminController@markpostAttendence')->name('markpostAttendence');
Route::post('/store-attendence', 'Admin\HrAdminController@storeattendence')->name('storeattendence');
Route::post('/attendence', 'Admin\HrAdminController@attendence')->name('searchattendence');





Route::get('/getDepartmentUseradmin/{id}', 'Admin\HrAdminController@getDepartmentUseradmin')->name('departmentUseradmin');


//Admin Lawyers
Route::get('/view-opencases-list', 'Admin\LawyersAdminController@viewOpencases')->name('viewOpencases');
Route::get('/view-closecases-list', 'Admin\LawyersAdminController@viewClosecases')->name('viewClosecases');

//Admin assets
Route::get('/Assetsheads', 'Admin\AssetAdminController@assetsheads')->name('assetsheads');
Route::post('/store-assethead', 'Admin\AssetAdminController@storehead')->name('storehead');
Route::post('/delete-asset-head', 'Admin\AssetAdminController@deletehead')->name('deletehead');
Route::post('/update-asset-head', 'Admin\AssetAdminController@updatehead')->name('updatehead');


Route::get('/assetmanagement', 'Admin\AssetAdminController@assetmanagement')->name('assetmanagement');
Route::post('/store-inventory', 'Admin\AssetAdminController@storeinventory')->name('storeinventory');
Route::post('/delete-inventory', 'Admin\AssetAdminController@deleteinventory')->name('deleteinventory');

Route::post('/update-asset-inventory', 'Admin\AssetAdminController@updateinventory')->name('updateinventory');

Route::post('/dispatch-inventory', 'Admin\AssetAdminController@assetdispatch')->name('assetdispatch');

Route::get('/assetdispatchhistory', 'Admin\AssetAdminController@assetdispatchhistory')->name('assetdispatchhistory');
Route::post('/assetdispatchhistory', 'Admin\AssetAdminController@assetdispatchhistory')->name('searchdispatch');


//reporting




/////Lawyer Routes


Route::get('/open-case-list', 'Lawyer\CaseController@caseslist')->name('caseslist');
Route::get('/close-case-list', 'Lawyer\CaseController@closecaseslist')->name('closecaseslist');


Route::post('/close-case', 'Lawyer\CaseController@closecase')->name('closecase');
Route::post('/reopen-case', 'Lawyer\CaseController@reopencase')->name('reopencase');
Route::post('/add-case-remarks', 'Lawyer\CaseController@addcaseremarks')->name('addcaseremarks');



/////Members Routes









Route::get('/send-file', 'Members\EfileController@sendfile')->name('sendfile');
Route::get('/send-letter', 'Members\EfileController@sendletter')->name('sendletter');
Route::get('/send-summary', 'Members\EfileController@sendsummary')->name('sendsummary');

Route::get('/current-file', 'Members\EfileController@currentfile')->name('currentfile');
Route::get('/sended-file', 'Members\EfileController@sendedfile')->name('sendedfile');
Route::get('/pending-file', 'Members\EfileController@pendingfile')->name('pendingfile');
Route::get('/approved-file', 'Members\EfileController@approvedfile')->name('approvedfile');
//getDepartmentUser
Route::get('/getDepartmentUser/{id}', 'Members\EfileController@getDepartmentUser')->name('departmentUser');

Route::get('/send-file-form', 'Members\EfileController@sendletterform')->name('sendfileform');
Route::get('/send-letter-form', 'Members\EfileController@sendletterform')->name('sendletterform');
Route::get('/send-summary-form', 'Members\EfileController@sendletterform')->name('sendsummaryform');



    



Route::post('/deletedraft', 'Members\EfileController@deletedraft')->name('deletedraft');

Route::post('/senddocument', 'Members\EfileController@senddocument')->name('senddocument');
Route::post('/senddoctodep', 'Members\EfileController@senddoctodep')->name('senddoctodep');
Route::post('/printdoc', 'Members\EfileController@printdoc')->name('printdoc');
Route::post('/printnoting', 'Members\EfileController@printnoting')->name('printnoting');



Route::post('/upload-efile', 'Members\EfileController@uploadefile')->name('uploadefile');
Route::post('/upload-efile-remarks', 'Members\EfileController@uploadefileproceed')->name('uploadefileproceed');







Route::get('/all-inbox-file', 'Members\EfileController@inboxfiles')->name('inboxfiles');
Route::get('/all-outbox-file', 'Members\EfileController@outboxfiles')->name('outboxfiles');


Route::get('/all-inbox-letter', 'Members\EfileController@inboxletter')->name('inboxletter');
Route::get('/all-outbox-letter', 'Members\EfileController@outboxletter')->name('outboxletter');


Route::get('/main-inbox-letter', 'Members\EfileController@maininboxletter')->name('maininboxletter');



Route::get('/all-inbox-notting', 'Members\EfileController@inboxnotting')->name('inboxnotting');
Route::get('/all-outbox-notting', 'Members\EfileController@outboxnotting')->name('outboxnotting');


//Reporting
Route::post('/reporting', 'Members\EfileController@reportingUser')->name('reportingUser');
Route::post('/reportingAdmin', 'Members\EfileController@reportingAdmin')->name('reportingAdmin');

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
