<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $efilesinbox = DB::table('efileshares')->where('shareto' , Auth::user()->id)->get();
        $efilesoutbox = DB::table('efileshares')->where('sharefrom' , Auth::user()->id)->get();
   
       
        $efiles = DB::table('draftshares')->where(function ($query) {$query->where('fromuser', Auth::user()->id)->orWhere('touser' , Auth::user()->id);})->where('doc_type', 1)->distinct()->get(['draft_id']);
         
          $eletters = DB::table('draftshares')->where(function ($query) {$query->where('fromuser', Auth::user()->id)->orWhere('touser' , Auth::user()->id);})->where('doc_type', 2)->distinct()->get(['draft_id']);
           $enottings = DB::table('draftshares')->where(function ($query) {$query->where('fromuser', Auth::user()->id)->orWhere('touser' , Auth::user()->id);})->where('doc_type', 3)->distinct()->get(['draft_id']);
       


           $draftscount = DB::table('draftshares')->where('doc_type' , 2)->where('fromuser' , Auth::user()->id)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
           
           
           $today = Carbon::today()->toDateString();
           $currentfiles = DB::table('draftshares')->where('doc_type' , 2)->where('touser' , Auth::user()->id)->where('close' , 0)->whereDate('created_at', $today)->where('approved' , 0)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
        
           $pendingfiles = DB::table('draftshares')->where('doc_type' , 2)->where('touser' , Auth::user()->id)->where('close' , 0)->whereDate('created_at', '<>', $today)->where('approved' , 0)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
          
          
       


           $sendedfiles = DB::table('draftshares')->where('doc_type' , 2)->where('fromuser' , Auth::user()->id)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
          
           
           $maininbox = DB::table('finaldocuments')->where('shareto' , Auth::user()->id)->get();


           if(Auth::user()->jobtitle == 'Secretary')
           {
              $Secapprovedfiles = DB::table('draftshares')->where('doc_type' , 2)->where('fromuser' , Auth::user()->id)->where('approved' , 1)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
              return view('home', ['maininbox' => $maininbox, 'efiles' => $efiles,'eletters' => $eletters , 'enottings' => $enottings, 'sendedfiles' => $sendedfiles,'currentfiles' => $currentfiles,'draftscount' => $draftscount, 'pendingfiles' => $pendingfiles, 'Secapprovedfiles' => $Secapprovedfiles]);
            }
           else
           {
              // $approvedfiles = DB::table('draftshares')->where('doc_type' , 2)->where('touser' , Auth::user()->id)->where('approved' , 1)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
               
              
              $getapprovedfiles = DB::table('draftshares')->where(function ($query) {
                $query->where('touser', Auth::user()->id)
                      ->orWhere('fromuser', Auth::user()->id);
                    })
                    ->where('doc_type', 2)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
            
                    $approvedfiles = DB::table('draftshares')
                    ->whereIn('draft_id', $getapprovedfiles->pluck('draft_id'))
                    ->where('approved', 1)
                    ->get();     
              return view('home', ['maininbox' => $maininbox, 'efiles' => $efiles,'eletters' => $eletters , 'enottings' => $enottings, 'sendedfiles' => $sendedfiles,'currentfiles' => $currentfiles,'draftscount' => $draftscount, 'pendingfiles' => $pendingfiles, 'approvedfiles'=> $approvedfiles]);
            }

          
    }
    
    
    
    
     public function homelawyer()
    {
        $getcasefile =   DB::connection('mysqllive')->table('lawyerfinaldocuments')->where('shareto' , Auth::user()->id)->get();
        return view('homelawyer', ['getcasefile' => $getcasefile]);
    }
    
    
    public function handleAdmin()
    {

        $users = DB::table('users')->get();
        $department = DB::table('departments')->get();
        $Odepartment = DB::table('odepartments')->get();
    
    
        $onleave = DB::table('leave_records')->where('date_start', '<=', date("Y-m-d"))->where('date_end', '>=', date("Y-m-d"))->get();
        
        
        $opencasecount =  DB::connection('mysqllive')->table('lawyerfinaldocuments')->where('caseclose', 0);
        $closecasecount =  DB::connection('mysqllive')->table('lawyerfinaldocuments')->where('caseclose', 1);
        
        return view('handleAdmin', ['users' => $users], ['department' => $department,'Odepartment' => $Odepartment ,'onleave' => $onleave, 'opencasecount' => $opencasecount,'closecasecount' => $closecasecount]);
    }    
    
    
    
}