<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Lawyers_user;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;




class MemberAdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function addmember()
    {
        $dep = DB::table('departments')->get();
        $jobtitles = DB::table('jobtiles')->get();
        $odep = DB::table('odepartments')->get();
        
   
        return view('admin-view.addMember', ['dep' => $dep, 'odep' => $odep, 'jobtitles' => $jobtitles]);

    }
    

    public function storemember(Request $request)
    {
        
     
            
            
            $fileModel = new User;
        
        if (isset($request->file))
     
        {
        $fileName = time().'_'.$request->file->getClientOriginalName();
        $filePath = $request->file('file')->storeAs('uploads', $fileName, 'public');
        $fileModel->attachment = '/storage/' . $filePath;
        }
        
        
        if($request->signature)
        {
        $fileName = time().'_'.$request->signature->getClientOriginalName();
        $filePath = $request->file('signature')->storeAs('uploads', $fileName, 'public');
        $fileModel->signature = '/storage/' . $filePath;
        }
       
        $fileModel->name = $request['membername'];
        $fileModel->email = $request['memberemail'];
        $fileModel->jobtitle = $request['jobtitle'];
        $fileModel->department_id = $request['memberdep'];
        $fileModel->odep_id = $request['odep'];
        $fileModel->allowleaves = $request['allowleaves'];
        $fileModel->date_of_joining = $request['date_of_joining'];
        $fileModel->date_of_transfer = $request['date_of_transfer'];
        $fileModel->job_status = $request['job_status'];
        $fileModel->active = $request['active'];
        $fileModel->notes = $request['notes'];
        $fileModel->date_of_transfer_out = $request['date_of_transfer_out'];
        $fileModel->password = Hash::make($request['memberpassword']);
        $fileModel->pin = Hash::make($request['memberpin']);
      
      
        if($request['jobtitle'] == 'Secretary')
        {
            $fileModel->scale_level = 1;
        }
        elseif($request['jobtitle'] == 'Draftsman')
        {
             $fileModel->scale_level = 2;
        }
        elseif( $request['jobtitle'] == 'AS')
        {
             $fileModel->scale_level = 3;
        }
        elseif($request['jobtitle'] == 'DS')
        {
             $fileModel->scale_level = 4;
        }
        elseif($request['jobtitle'] == 'SO')
        {
             $fileModel->scale_level = 5;
        }
        elseif($request['jobtitle'] == 'SC')
        {
             $fileModel->scale_level = 6;
        }
        
        
        
        $fileModel->save();
        
        
        
        

        // }

        $dep = DB::table('departments')->get();
           $jobtitles = DB::table('jobtiles')->get();
        $odep = DB::table('odepartments')->get();
        return view('admin-view.addMember', ['dep' => $dep, 'odep' => $odep, 'jobtitles' => $jobtitles]);
    }



    public function viewmembers()
    {
        $members = DB::table('users')->where('is_deleted' , 0)->where('is_admin' , 0)->orWhere('is_admin' , Null)->get();
         $jobtitles = DB::table('jobtiles')->get();
$getdeparts = DB::table('departments')->get();
$getOdeparts = DB::table('odepartments')->get();






        return view('admin-view.viewMembers', ['members' => $members, 'jobtitles' => $jobtitles, 'getdeparts' => $getdeparts, 'getOdeparts' => $getOdeparts]);
      
    }
    
    
    
    public function uploademember(Request $request)
    {
        
        
            $updatemember = User::find($request['id']);



                    if (isset($request->file))
                    {
                    $fileName = time().'_'.$request->file->getClientOriginalName();
                    $filePath = $request->file('file')->storeAs('uploads', $fileName, 'public');
                    $updatemember->attachment = '/storage/' . $filePath;
                    }
                    
                    
                    if($request->signature)
                    {
                    $fileName = time().'_'.$request->signature->getClientOriginalName();
                    $filePath = $request->file('signature')->storeAs('uploads', $fileName, 'public');
                    $updatemember->signature = '/storage/' . $filePath;
                    }



 

            $updatemember->name = $request['name'];
            $updatemember->jobtitle = $request['jobtitle'];
            $updatemember->email = $request['email'];
            $updatemember->department_id = $request['depid'];
          //  $updatemember->odep_id = $request['Odepid'];
            $updatemember->allowleaves = $request['allowleaves'];
      

            $updatemember->date_of_joining = $request['date_of_joining'];
            $updatemember->date_of_transfer = $request['date_of_transfer'];
            $updatemember->job_status = $request['job_status'];
            $updatemember->active = $request['active'];
            $updatemember->notes = $request['notes'];
            $updatemember->date_of_transfer_out = $request['date_of_transfer_out'];
           
            if($request->memberpassword)
                    {
                        $updatemember->password = Hash::make($request['memberpassword']);

                    }
            if($request->memberpin)
                    {
                        $updatemember->pin = Hash::make($request['memberpin']);

                    }
           
          


            
            
            $updatemember->updated_at = Carbon::now();
            $updatemember->save();
             return redirect()->back();
    }
    
    
    
    public function deletemember(Request $request)
    {
       
        
          $softdelete = User::find($request['userid']);
           $softdelete->updated_at = Carbon::now();
            $softdelete->is_deleted = 1;
     
           
            $softdelete->save();
             return redirect()->back();
             
            
    }
    
    
    
    
    
    
    
    
    
    




    
 
}