<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Department;
use App\Models\Jobtile;
use App\Models\Leave_record;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;



class HrAdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
     
     public function getDepartmentUseradmin($department)
    {
        // $data = SubCategory::where('category_id',$category_id)->get();
        // \Log::info($data);
         $data =  DB::table('users')->where('odep_id' , $department)->where('is_admin' , 0)->orWhere('is_admin' , Null)->get();
         
        return response()->json(['data' => $data]);
    }
    
    
    
    
    public function attendence(Request $request)
    {
        
       
        
        if($request->member AND $request->department)
        {
             $leaverecords = DB::table('leave_records')->where('userid', $request->member)->where('depid', $request->department)->orderBy('id', 'DESC')->get();
        }
        elseif($request->department)
        {
             $leaverecords = DB::table('leave_records')->where('depid', $request->department)->whereBetween('date_start', [$request->leavefrom, $request->leavetill])->orderBy('id', 'DESC')->get();
        }
        
        
        
     
        
        
        
        else
        {
             $data = DB::table('leave_records')->orderBy('id', 'DESC')->get();
            //$leaverecords = DB::table('leave_records')->distinct('userid')->pluck('userid')->get();
            
  
        $leaverecords  = collect($data)->unique('userid');
  
     
            
        }
        
        
        $Odep = DB::table('odepartments')->get();
        
        $members = DB::table('users')->where('is_admin' , 0)->orWhere('is_admin' , Null)->get();
        return view('admin-view.searchAttendence', ['members' => $members, 'leaverecords' => $leaverecords, 'Odep' => $Odep]);
        
    }
    
    public function markattendence()
    {
        $department = DB::table('odepartments')->get();
        return view('admin-view.markAttendence', ['department' => $department]);
        
    }
    
    
    
    public function markpostAttendence(Request $request)
    {
        $depname = $request->odep;
        $members = DB::table('users')->where('odep_id' , $request->odep)->get();
        return view('admin-view.markpostAttendence', ['members' => $members, 'depname' => $depname]);
        
    }
    
    public function storeattendence(Request $request)
    {
        
        $count = count($request->userid);
        
        
        for($i = 0;$i<$count;$i++)
        {
        
        if($request->status[$i] == 'Leave')
        {
            
           



            if(isset($request->file[$i]))
            {
                
                
                        $formatted_dt1=Carbon::parse($request->leavetill[$i]);
                        $formatted_dt2=Carbon::parse($request->leavefrom[$i]);
                        $days =  $formatted_dt2->diffInDays($formatted_dt1);
                   
                   
                   
                    $fileName = time().'_'.$request->file[$i]->getClientOriginalName();
                    $filePath = $request->file[$i]->storeAs('uploads', $fileName, 'public');
                    
            
            Leave_record::insert([
            'userid' => $request->userid[$i],
            'depid' => $request->depid[$i],
            'username' => $request->username[$i],
            'date_start' => $request->leavefrom[$i],
            'date_end' => $request->leavetill[$i],
            'status' => $request->status[$i],
            'leave_type' => $request->reason[$i],
            'dayscount' => $days+1,
            'file_path' => 'app/public/' . $filePath
            ]);
            
            }
            else
            {
                        $formatted_dt1=Carbon::parse($request->leavetill[$i]);
                        $formatted_dt2=Carbon::parse($request->leavefrom[$i]);
                        $days =  $formatted_dt2->diffInDays($formatted_dt1);
                 
            Leave_record::insert([
            'userid' => $request->userid[$i],
            'depid' => $request->depid[$i],
            'username' => $request->username[$i],
            'date_start' => $request->leavefrom[$i],
            'date_end' => $request->leavetill[$i],
            'status' => $request->status[$i],
            'leave_type' => $request->reason[$i],
             'dayscount' => $days+1
            ]);
            }
        
        
        
        
        }
        
        
        }
        
        
        
        
        
        $department = DB::table('odepartments')->get();
        return view('admin-view.markAttendence', ['department' => $department]);
        
    }





    public function reportingAdmin(Request $request)
        {
            if (isset($request->searchtext)) 
                {
                    $searchResults = Efileshare::where('doc_no', $request->searchtext)->orWhere('subject', $request->searchtext)->get();
                    
                    $searchSuggestion = Efileshare::latest()->get();
                    $today = Carbon::today()->toDateString();
                    $users = DB::table('users')->where('odep_id' , Auth::user()->odep_id)->where('id', '<>' ,Auth::user()->id)->where('is_admin' , 0)->get();
                    $current = DB::table('draftshares')->where('doc_type' , 2)->where('close' , 0)->whereDate('created_at', $today)->where('approved' , 0)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
                    $pending = DB::table('draftshares')->where('doc_type' , 2)->where('close' , 0)->where('approved' , 0)->whereDate('created_at', '<>', $today)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
                    $approved = DB::table('draftshares')->where('doc_type' , 2)->where('approved' , 1)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
                    return view('member-view.reporting', ['users' => $users, 'current' => $current, 'pending' => $pending, 'approved' => $approved, 'searchResults' => $searchResults, 'searchSuggestion' => $searchSuggestion]);
                }

            else
                {
                $searchSuggestion = Efileshare::latest()->get();
                $today = Carbon::today()->toDateString();
                $users = DB::table('users')->where('odep_id' , Auth::user()->odep_id)->where('id', '<>' ,Auth::user()->id)->where('is_admin' , 0)->get();
                $current = DB::table('draftshares')->where('doc_type' , 2)->where('close' , 0)->whereDate('created_at', $today)->where('approved' , 0)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
                $pending = DB::table('draftshares')->where('doc_type' , 2)->where('close' , 0)->where('approved' , 0)->whereDate('created_at', '<>', $today)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
                $approved = DB::table('draftshares')->where('doc_type' , 2)->where('approved' , 1)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
                return view('member-view.reporting', ['users' => $users, 'current' => $current, 'pending' => $pending, 'approved' => $approved, 'searchSuggestion' => $searchSuggestion]);
                }
        }
    
    
    

    

    
 
}