<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Department;
use App\Models\Jobtile;
use App\Models\Asset_head;
use App\Models\Inventory_stock;
use App\Models\Dispatch_inventories;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;



class AssetAdminController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

     
     public function assetsheads(Request $request)
    {
        
        $data =  DB::table('asset_heads')->get();
        return view('admin-view.assethead', ['data' => $data]);
    }
    
    
    
    
    public function storehead(Request $request)
    {
        
            
            Asset_head::insert([
            'name' => $request->headname,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
            ]);
          
          
       $data =  DB::table('asset_heads')->get();
        return view('admin-view.assethead', ['data' => $data]);
        
    }
    
    public function deletehead(Request $request)
    {
    DB::table('asset_heads')->delete($request->delid);
    $data =  DB::table('asset_heads')->get();
        return view('admin-view.assethead', ['data' => $data]);
    }
    
    
    public function deleteinventory(Request $request)
    {
    DB::table('inventory_stocks')->delete($request->delid);
   $departmentlist=  DB::table('odepartments')->get();
        $sectionlist=  DB::table('departments')->get();
         $inventoryitems =  DB::table('inventory_stocks')->get();
        
        $data =  DB::table('asset_heads')->get();
        return view('admin-view.assetmanagement', ['data' => $data, 'inventoryitems' => $inventoryitems, 'departmentlist' => $departmentlist, 'sectionlist' => $sectionlist]);
    }
    
    
    
    
        public function updatehead(Request $request)
    {
        
        
            $updatehead = Asset_head::find($request['id']);
            $updatehead->name = $request['headname'];
        
            
            $updatehead->updated_at = Carbon::now();
            $updatehead->save();
        $data =  DB::table('asset_heads')->get();
        return view('admin-view.assethead', ['data' => $data]);
    }
    
    
    
    
    public function assetmanagement(Request $request)
    {
        $departmentlist=  DB::table('odepartments')->get();
        $sectionlist=  DB::table('departments')->get();
         $inventoryitems =  DB::table('inventory_stocks')->get();
        
        $data =  DB::table('asset_heads')->get();
        return view('admin-view.assetmanagement', ['data' => $data, 'inventoryitems' => $inventoryitems, 'departmentlist' => $departmentlist, 'sectionlist' => $sectionlist]);
    }
    
    
    
    
    public function storeinventory(Request $request)
    {
        
            
            Inventory_stock::insert([
            'cat_id' => $request->category,
            'itemname' => $request->item_name,
            'qty_instock' => $request->item_qty,
            'qty_consumed' => 0,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
            ]);
          
          
      $departmentlist=  DB::table('odepartments')->get();
        $sectionlist=  DB::table('departments')->get();
         $inventoryitems =  DB::table('inventory_stocks')->get();
        
        $data =  DB::table('asset_heads')->get();
        return view('admin-view.assetmanagement', ['data' => $data, 'inventoryitems' => $inventoryitems, 'departmentlist' => $departmentlist, 'sectionlist' => $sectionlist]);
        
    }
    
    
    
    
    public function updateinventory(Request $request)
    {
        
        
            $updatehead = Inventory_stock::find($request['id']);
            $updatehead->cat_id = $request['cat'];
            $updatehead->itemname = $request['itemname'];
            $updatehead->qty_instock = $request['itemqty'];
            
            $updatehead->updated_at = Carbon::now();
            $updatehead->save();
            
         $departmentlist=  DB::table('odepartments')->get();
        $sectionlist=  DB::table('departments')->get();
         $inventoryitems =  DB::table('inventory_stocks')->get();
        
        $data =  DB::table('asset_heads')->get();
        return view('admin-view.assetmanagement', ['data' => $data, 'inventoryitems' => $inventoryitems, 'departmentlist' => $departmentlist, 'sectionlist' => $sectionlist]);
    }
    
    
    
     public function assetdispatch(Request $request)
    {
        
            $getitemdetails =  DB::table('inventory_stocks')->where('id' , $request->itemname)->first();
            $getremainingqty = $getitemdetails->qty_instock - $request->issue_quantity;
            
            
            Dispatch_inventories::insert([
                
           
            
            'department_id' => $request->department,
            'section_id' => $request->section,
            'cat_id' => $request->catname,
            'name' => $getitemdetails->itemname,
            'qty_issue' => $request->issue_quantity,
            'qty_left' => $getremainingqty,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
            ]);
            
            
             $getinvent =  DB::table('inventory_stocks')->where('id' , $request->itemname)->first();
            
            
            
            
            $updatestock = Inventory_stock::find($getitemdetails->id);
            
            $updatestock->qty_instock = $getremainingqty;
            $updatestock->qty_consumed = $request->issue_quantity+ $getinvent->qty_consumed;
            
            $updatestock->updated_at = Carbon::now();
            $updatestock->save();
            
            
            
          
          
        $departmentlist=  DB::table('odepartments')->get();
        $sectionlist=  DB::table('departments')->get();
         $inventoryitems =  DB::table('inventory_stocks')->get();
        
        $data =  DB::table('asset_heads')->get();
        return view('admin-view.assetmanagement', ['data' => $data, 'inventoryitems' => $inventoryitems, 'departmentlist' => $departmentlist, 'sectionlist' => $sectionlist]);
        
    }
    
    
    
    
    public function assetdispatchhistory(Request $request)
    {   
     
  

  
        if($request->department AND $request->section)
        {
            
             $dispatchhistory = DB::table('dispatch_inventories')->where('department_id', $request->department)->where('section_id', $request->section)->whereBetween('created_at', [$request->dispatchfrom, $request->dispatchtill])->orderBy('id', 'DESC')->get();
        }
        elseif($request->department)
        {
            
             $dispatchhistory = DB::table('dispatch_inventories')->where('department_id', $request->department)->whereBetween('created_at', [$request->dispatchfrom, $request->dispatchtill])->orderBy('id', 'DESC')->get();
        }
        elseif($request->section)
        {
        
             $dispatchhistory = DB::table('dispatch_inventories')->where('section_id', $request->section)->whereBetween('created_at', [$request->dispatchfrom, $request->dispatchtill])->orderBy('id', 'DESC')->get();
        }
        
        else
        {
           
             $dispatchhistory=  DB::table('dispatch_inventories')->orderBy('id', 'DESC')->get();
        }
        
        
        
        $departmentlist=  DB::table('odepartments')->get();
        $sectionlist=  DB::table('departments')->get();
       

        return view('admin-view.assethistory', ['dispatchhistory' => $dispatchhistory, 'departmentlist' => $departmentlist, 'sectionlist' => $sectionlist]);
    }
    
    
    
    public function searchdispatch(Request $request)
    {
        if($request->member AND $request->department)
        {
             $leaverecords = DB::table('leave_records')->where('userid', $request->member)->where('depid', $request->department)->orderBy('id', 'DESC')->get();
        }
        elseif($request->department)
        {
             $leaverecords = DB::table('leave_records')->where('depid', $request->department)->whereBetween('date_start', [$request->leavefrom, $request->leavetill])->orderBy('id', 'DESC')->get();
        }
        else
        {
             $data = DB::table('leave_records')->orderBy('id', 'DESC')->get();
        $leaverecords  = collect($data)->unique('userid');
        }
        $Odep = DB::table('odepartments')->get();
        $members = DB::table('users')->where('is_admin' , 0)->orWhere('is_admin' , Null)->get();
        return view('admin-view.searchAttendence', ['members' => $members, 'leaverecords' => $leaverecords, 'Odep' => $Odep]);
        
    }
    
    
    
    
    
    
    
    

    

    
 
}